VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Public Host As Object

Private Winamp As New clsWinamp

'### Vanquish v2.0 Plugin Structure created by Networks ###
'### Contact Information: DigitalWarfare@gmail.com [http://www.ZeroForce.net/]
'### Revision: 5 ###

'Host Functions:
    ' + AddQueue <Message>, <Optional Priority> [Example: Call Host.AddQueue("Vanquish Bot v2.0 by Networks", 1)]
    ' + SendCommandReply <username> <message> [optional force whisper?], [optional priority byte] (Example: Call Host.SendCommandReply("Networks", "Hello.", False, 0)
    ' + Get_Flags <username>, <DB_Type> (Use enumeration) [Example: Msgbox Host.Get_Flags("Networks", DB_Types.User)] (Return type is the user's flags in string format)
    ' + Get_Trigger (Returns bot's trigger (string)) [Example: msgbox Host.Get_Trigger]
    ' + Ban <Message>, <Optional Message> <Optional UseQueue (Boolean)> (Uses bot's internal ban function) [Example: Host.Ban(Username, "You suck!", True)] (By default the bot will ALWAYS use the queue.)
    ' + ClearQueue [Example: Call Host.ClearQueue] (Will clear the queue in which messages are held in.)
    ' + Close_Bot [Example: Call Host.Close_Bot] (Closes the connections.]
    ' + Connect_Bot [Example: Call Host.Connect_Bot] (Attempts to connect the bot using the bots internal connection sub.]
    ' + Send <message> [Example: Host.Send "Vanquish Bot v2.0"] (Sends a raw message to battle.ne without the queue.]
    ' + Has_Ops [Example: If Host.Has_Ops Then] (Returns True/False whether the bot has operator status. Return type is a boolean.)
    ' + Get_Path [Example: strApp_Path = Host.Get_Path] (Returns the executable's path to allow the user to access other files such as the database, configuration file, etc.)
    ' + Get_FrmhWnd [Example: lngFrmhWnd = Host.Get_FrmhWnd] (Returns the forms handle, type: Long)
    ' + Get_Username [Example: strUsername = Host.Get_Username] (Returns the username which the bot is currently logged on.)
    ' + Get_Product [Example: strProduct = Host.Get_Product] (Returns the 4 letter string ID for the product it's on in reverse.)
    ' + Get_Channel [Example: strChannel = Host.Get_Channel] (Returns the channel the bot may be in.)
    ' + Get_LastMessageSent [Example: lngLastMessage = Host.Get_LastMessageSent] (Returns the time (GetTickCount() Format) of when the last message was sent by the queue.)
    ' + isConnected [Example: boolConnected = Host.isConnected] (Returns whether the bot is or is not connected to a server. Type: Boolean)
    ' + Unload_Plugin [Example: Host.Unload_Plugin(app.ProjectName & ".dll") (The plugins tells the host to unload itself, you MUST add .dll at the end since that's the plugin's official name.)
    ' + Packet Buffer Functions/Subs:
    '       - Public Function GetDWORD(ByVal strData As String) As Long
    '       - Public Function GetWORD(ByVal strData As String) As Long
    '       - Public Sub InsertBYTE(ByVal intData As Integer)
    '       - Public Sub InsertDWORD(ByVal lngData As Long)
    '       - Public Sub InsertNonNTString(ByVal strData As String)
    '       - Public Sub InsertNTString(ByVal strData As String)
    '       - Public Sub InsertWORD(ByVal intData As Integer)
    '       - Public Function MakeDWORD(ByVal lngValue As Long) As String
    '       - Public Sub SendPacketBNCS(ByVal bytPacketID As Byte)
    '       - Public Sub SendPacketBNLS(ByVal bytPacketID As Byte)

' /* Events (BNCS => SID_CHATEVENT) Constants
Private Const EID_EMOTE = &H17
Private Const EID_WHISPTO = &HA
Private Const EID_WHISPFROM = &H4
Private Const EID_TALK = &H5
Private Const EID_USER = &H1
Private Const EID_JOIN = &H2
Private Const EID_LEAVE = &H3
Private Const EID_FLAGS = &H9
Private Const EID_CHAN = &H7
Private Const EID_ERROR = &H13
Private Const EID_INFO = &H12
Private Const EID_NOTEXIST = &HE
Private Const EID_BROADCAST = &H6
Private Const EID_RESTRICTED = &HF
Private Const EID_CHANFULL = &HD
'*/

'/* Database Vars:
Enum DB_Types
    Group
    Master
    User
End Enum
'*/

Private Sub Class_Initialize()
    'When plugin is loaded.
End Sub

Private Sub Class_Terminate()
    'When plugin is unloaded.
    Set Host = Nothing
End Sub

' /* Plugin information (REQUIRED):
Public Property Get Version() As String
    Version = "1.0.0"
End Property

Public Property Get Title() As String
    Title = "Winamp Plugin by Networks"
End Property

Public Property Get Description() As String
    Description = "Provides a way to interact with the software known as winamp using commands via the host of this plugin."
End Property

Public Function SetHost(newHost As Object) As Boolean
'ALERT: THE BOT WILL NOT LOAD THE PLUGIN WITHOUT A TRUE RESPONSE FROM THIS.
    Set Host = newHost
    SetHost = True
End Function
'*/

' /* Events (BNCS => 0xFF):
Public Sub Events(ByVal EID As Long, ByVal Username As String, ByVal Flags As Long, ByVal Ping As Long, ByVal Client As String, ByVal Message As String)
'// Information: Use passed vars where applicable (IE: Do not use Username for EID_INFO and etc.)
'// Information: You WILL recieve the mangled Diablo II '*' usernames. (Example: '*Networks')
    Select Case EID
        '
    End Select
End Sub
'*/

'/* Packet Parsing (BNCS Byte => 1 && BNLS Byte => 2) (Data will contain the packet ID)
Public Sub Parse_Packets(ByVal Connection As Byte, ByVal PacketID As Long, ByVal Data As String)
    Select Case Connection
        Case 1 'BNCS
        
        Case 2 'BNLS
        
        Case Else 'Unknown?
    End Select
End Sub
'*/

'/* Command Central
Public Function Command(ByVal Username As String, ByVal Message As String) As Boolean 'Initiates when the bot's internal command processor does.
'// Information: Message (This is the statement split by semi-colons and after aliasing, you will NOT recieve the entire message sent.)
    '(Advisory: Do not remove this allows the bot to count the command and log it.)
'// Information: Please ensure that if NO COMMMAND has been issued then set Command = False.
'                   or you may set Command = False initially and set Command = True after every command statement.
    Dim userFlags As String
    userFlags = Host.Get_Flags(Username, User)
    If InStr(userFlags, "A") Then 'A (Adminstrator) flag
        If Winamp_Command(Message) = True Then
            Command = True
        End If
    End If
    
End Function
'*/

'/* Inbot Commands via the text box
Public Function InBotCommand(ByVal strText As String)
    If Left$(strText, 1) = "\" Then
        Call Winamp_Command(Right$(strText, Len(strText) - 1))
    End If
End Function
'*/

Private Sub AddQueue(ByVal Message As String)
    Host.AddQueue Message
End Sub

Private Sub Broadcast_Winamp_SongTitle()
    Dim strTitle As String
    strTitle = Winamp.GetWinampSongTitle(False)
    If (strTitle <> vbNullString) Then
        AddQueue "Currently playing: " & strTitle & " (" & Winamp.GetCurrentSongPosition _
        & "/" & Winamp.GetCurrentSongLength & ") at " & Winamp.GetBitrate & " (kbps), " & Winamp.GetSamplerate _
        & " (kHz)."
    End If
End Sub

Private Function Winamp_Command(ByVal Message As String) As Boolean
    On Error Resume Next
    Dim SpltCmd() As String
    SpltCmd() = Split(Message, Space(1)) 'Tokenize the string and place into array based on space values
    Winamp_Command = True
    
    Select Case LCase$(SpltCmd(0))
        Case "next"     'moves foward one song
            Winamp.Execute WA_Next_track
            Call Broadcast_Winamp_SongTitle
        Case "back"     'steps backward one song
            Winamp.Execute WA_Previous_track
            Call Broadcast_Winamp_SongTitle
            
        Case "stop"     'stops a current song
            Winamp.Execute WA_STOP
            AddQueue "Winamp has stopped playing."
            
        Case "pause"
            Winamp.Execute WA_Pause_Unpause
            AddQueue "Winamp has been paused/unpaused."
            
        Case "play"     'plays a current song
            Winamp.Execute WA_PLAY
            Call Broadcast_Winamp_SongTitle
            
        Case "close"    'closes winamp
            Winamp.Execute WA_Close_Winamp
            If (Winamp.FindWinAMP = False) Then
                AddQueue "Winamp has closed."
            End If
            
        Case "foward"   '5 seconds only
            Winamp.Execute WA_Fast_forward_5_seconds
            
        Case "backward" '5 seconds only
            Winamp.Execute WA_Fast_rewind_5_seconds
            
        Case "fadeoutstop"
            Winamp.Execute WA_Fadeout_and_stop
        
        Case "setvolume"
            'Usage: <trigger>Setvolume 30 (Integer value is actually a percent)
            Dim intVolume As Integer
            intVolume = Val(SpltCmd(1))         'Make it into a real number value
            intVolume = 255 * (intVolume / 100) 'Break the percent down to a real value the method can use
            Winamp.SetVolume intVolume          'Set volume
            AddQueue "Desired volume was set at " & Int(((intVolume / 255) * 100)) & "%"
        
        Case "playbackstatus"
            Select Case Winamp.PlaybackStatus
                Case 0 'Stopped
                    AddQueue "Winamp has currently stopped playing."
                Case 1 'Playing
                    Call Broadcast_Winamp_SongTitle
                Case 3 'Paused
                    AddQueue "Winamp is currently paused."
            End Select
        
        Case "back10tracks"
            Winamp.Execute WA_Moves_back_10_tracks_in_playlist
            AddQueue "Currently playing: " & Winamp.GetWinampSongTitle(True)
        
        Case "firstsong"
            Winamp.Execute WA_Start_of_playlist
            AddQueue "Currently playing: " & Winamp.GetWinampSongTitle(True)
            
        Case "lastsong"
            Winamp.Execute WA_Go_to_end_of_playlist
            AddQueue "Currently playing: " & Winamp.GetWinampSongTitle(True)
            
        Case Else
            Winamp_Command = False
            
    End Select
End Function
